import numpy
import matplotlib.pyplot as pyplot
import scipy.optimize as optimise
from jqc import jqc_plot
import os
import scipy.constants as const
import matplotlib.gridspec as gridspec
import matplotlib.patches as patches

a0 = const.physical_constants['Bohr radius'][0]
c = const.c
h = const.h
pi = numpy.pi
eps0 = const.epsilon_0

Grid = gridspec.GridSpec(2,2,width_ratios=[3,2])
cwd = os.path.dirname(os.path.abspath(__file__))

jqc_plot.plot_style('normal')

wplate_offset = (90-43.93)
Ts = 0.781
Tp = 0.99468
WattsPerVolt = 0.985
red = jqc_plot.colours['red']

blue = jqc_plot.colours['blue']

alpha_0 = 2020 #a0**3
alpha_2 = 1996 #a0**3

fig = pyplot.figure("Angles")
ax1 = fig.add_subplot(Grid[1,0])
ax2 = fig.add_subplot(Grid[1,1])
ax3 = fig.add_subplot(Grid[0,0],sharex=ax1)
ax4 = fig.add_subplot(Grid[0,1],sharex=ax2)

P2 = lambda x,I,alpha_2: -(0.4*I*alpha_2/(2*eps0*c))*(3*numpy.cos(numpy.deg2rad(x))**2-1)/2

############## 181 G Data ######################################################
data = numpy.genfromtxt(cwd+"\\Data\\EXP\\Angle_variation_181G.csv",delimiter=',')
f0=980231 #kHz

P = data[:,3]*data[:,4]*WattsPerVolt
Pavg = numpy.mean(P)
stdP = numpy.std(P)

Intensity = (Pavg*2)/(pi*172.6e-6**2)
shift = 1e-3*Intensity * (alpha_2 * 4*pi*eps0*a0**3)/(2*eps0*c*h)
tp = numpy.sqrt(Tp)
ts = numpy.sqrt(Ts)


angles = data[:,0]
angles = 2*(angles - wplate_offset)

angles_cell = numpy.rad2deg(
                        numpy.arctan((tp/ts)*numpy.tan(numpy.deg2rad(angles))))

ax3.errorbar(angles_cell,1e3*(data[:,1]),yerr=1e3*data[:,2],xerr=1.,fmt='o',
                color='k',zorder=1.6,label="181.5 G",capsize=3.5)


########### Angle theory ######################################################


Angle_theory_181= numpy.genfromtxt(
                            cwd+"\\Data\\Angles_181G.csv",delimiter=',')

Angle_theory_181_m = numpy.genfromtxt(
                            cwd+"\\Data\\Angles_181G_m.csv",delimiter=',')

Angle_theory_181_p = numpy.genfromtxt(
                            cwd+"\\Data\\Angles_181G_p.csv",delimiter=',')



Transition = 1e-3*(Angle_theory_181[33,:]-Angle_theory_181[1,:])/h


Transition_m = 1e-3*(Angle_theory_181_m[33,:]-Angle_theory_181_m[1,:])/h


Transition_p = 1e-3*(Angle_theory_181_p[33,:]-Angle_theory_181_p[1,:])/h

ax3.plot(Angle_theory_181[0,:],Transition-f0,zorder=1.1,
                color=jqc_plot.colours['blue'])

ax3.fill_between(Angle_theory_181[0,:],Transition_m-f0,Transition_p-f0,
                color=jqc_plot.colours['blue'],alpha=0.5,edgecolor='none')

ax3.plot(Angle_theory_181[0,:],1e-3*P2(Angle_theory_181[0,:],1.1e7,
        alpha_2*4*pi*eps0*a0**3)/h,color=jqc_plot.colours['grayblue'],ls='--',zorder=1.01)

#### Intensity Variation #######################


intensity_theory= numpy.genfromtxt(
                            cwd+"\\Data\\181G[Intensity theory]\\Lines_63.csv",delimiter=',')

intensity_theory_m= numpy.genfromtxt(
                            cwd+"\\Data\\181G[Intensity theory]\\Lines_62.csv",delimiter=',')


intensity_theory_p= numpy.genfromtxt(
                            cwd+"\\Data\\181G[Intensity theory]\\Lines_64.csv",delimiter=',')


intensity_data = numpy.genfromtxt(
                cwd+"\\Data\\EXP\\Intensity_Variation_181G_B63.csv",delimiter=',')

intensity_data[:,0] = 0.944851*1e-7*intensity_data[:,0]*2*WattsPerVolt/(pi*172.6e-6**2)

Transition = 1e-3*(intensity_theory[33,:]-intensity_theory[1,:])/h

Transition_m = 1e-3*(intensity_theory_m[33,:]-intensity_theory_m[1,:])/h

Transition_p = 1e-3*(intensity_theory_p[33,:]-intensity_theory_p[1,:])/h

ax4.plot(intensity_theory[0,:],Transition[:]-Transition[0],
        color=jqc_plot.colours['blue'],zorder=1.1)
ax4.fill_between(intensity_theory[0,:],Transition_m-Transition_m[0],
                    Transition_p-Transition_p[0],alpha=0.5,
                    facecolor=jqc_plot.colours['blue'],edgecolor='none',
                    zorder=1.05)

ax4.errorbar(intensity_data[:,0],intensity_data[:,1]-f0,yerr=intensity_data[:,2],
                fmt ='o',color='k',zorder=1.2)


############## 350 G Data ######################################################
data = numpy.genfromtxt(cwd+"\\Data\\EXP\\Angle_variation_350G.csv",delimiter=',')
f0 = 980.2492e3
P = data[:,3]*data[:,4]*WattsPerVolt
Pavg = numpy.mean(P)
stdP = numpy.std(P)

Intensity = (Pavg*2)/(pi*172.6e-6**2)

shift = 1e-3*Intensity * (alpha_2 * 4*pi*eps0*a0**3)/(2*eps0*c*h)
tp = numpy.sqrt(Tp)
ts = numpy.sqrt(Ts)

angles = data[:,0]
angles = 2*(angles - wplate_offset)

angles_cell = numpy.rad2deg(
                        numpy.arctan((tp/ts)*numpy.tan(numpy.deg2rad(angles))))

ax1.errorbar(angles_cell,1e3*(data[:,1]),yerr=1e3*data[:,2],xerr=1.,fmt='o',
                ecolor='k',markeredgecolor='k',markerfacecolor='k',zorder=1.6,label="355 G",capsize=3.5)


###############Intensity Variation #################

intensity_theory= numpy.genfromtxt(
                            cwd+"\\Data\\350G[Intensity theory]\\Lines63.dat")
intensity_theory_m= numpy.genfromtxt(
                            cwd+"\\Data\\350G[Intensity theory]\\Lines62.dat")
intensity_theory_p= numpy.genfromtxt(
                            cwd+"\\Data\\350G[Intensity theory]\\Lines64.dat")
intensity_data = numpy.genfromtxt(
                cwd+"\\Data\\EXP\\Intensity_Variation_350G_B63.csv",delimiter=',')

intensity_data[:,0] = 0.944851*1e-7*intensity_data[:,0]*2*WattsPerVolt/(pi*172.6e-6**2)

ax2.plot(intensity_theory[:,0]*1e-3,intensity_theory[:,1:5]-f0,
        color=jqc_plot.colours['red'],zorder=1.1)
ax2.fill_between(intensity_theory[:,0]*1e-3,intensity_theory_m[:,1]-f0,
                    intensity_theory_p[:,1]-f0,facecolor=jqc_plot.colours['red'],
                    edgecolor='none',alpha=0.5,zorder=1.05)

ax2.errorbar(intensity_data[:,0],intensity_data[:,1]*1e3-f0,yerr=1e3*intensity_data[:,2],
                fmt ='o',color='k',zorder=1.2)


####### Angle Theory ################

f0 = 980.2492e3

Angle_theory_355= numpy.genfromtxt(
                            cwd+"\\Data\\Angles_355G.csv",delimiter=',')

Transition = 1e-3*(Angle_theory_355[33,:]-Angle_theory_355[1,:])/h
ax1.plot(Angle_theory_355[0,:],Transition-f0,zorder=1.1,
                color=jqc_plot.colours['red'])





ax1.plot(Angle_theory_181[0,:],1e-3*P2(Angle_theory_181[0,:],1.1e7,
        alpha_2*4*pi*eps0*a0**3)/h,color=jqc_plot.colours['reddish'],ls='--',zorder=1.01)


#ax1.text(0.88,0.04,"(a)",transform=ax1.transAxes)
########### Setup Plot ########################################################

ax1.set_ylim(-45,25)
ax3.set_ylim(-45,25)

ax2.set_xlim(0,2.25)
ax2.set_ylim(-20,5)

ax2.set_ylim(-25,12)
ax4.set_ylim(-25,12)

ymin,ymax = ax1.get_ylim()

ax1.plot([54.74,54.74],[ymin,ymax],ls='--',color='k')
ax1.plot([63,63],[ymin,ymax],ls=':',color='k')



ymin,ymax = ax3.get_ylim()
ax3.plot([54.74,54.74],[ymin,ymax],ls='--',color='k')
ax3.plot([63,63],[ymin,ymax],ls=':',color='k')

ax3.set_xticks([0,45,90])
ax1.set_xlabel("Polarisation Angle, $\\beta$ ($^\\circ$)")

ax2.set_xlabel("Intensity (kW$\\,$cm$^{-2}$)")

pyplot.setp(ax4.get_xticklabels(),visible=False)
pyplot.setp(ax3.get_xticklabels(),visible=False)


ax1.text(-0.3,1.0,"Transition Frequency Shift (kHz)",
            verticalalignment='center',rotation=90,transform=ax1.transAxes)
ax2.text(-0.45,1.0,"Transition Frequency Shift (kHz)",
            verticalalignment='center',rotation=90,transform=ax2.transAxes)

ax2.arrow(1.08,2,0,-2,length_includes_head=True,transform=ax2.transAxes,
        clip_on=False,width=.02,color='k')

ax2.text(1.15,1.,"Increasing $B$",rotation = 90, fontsize=15,
        verticalalignment='center',transform=ax2.transAxes)
ax3.set_xlim(-5,95)

ax3.text(0.03,0.85,"(a)",transform=ax3.transAxes,fontsize=20)
ax3.text(0.92,0.08,"(i)",transform = ax3.transAxes,fontsize=20,horizontalalignment='center')
ax1.text(0.92,0.08,"(ii)",transform = ax1.transAxes,fontsize=20,horizontalalignment='center')


ax4.text(0.03,0.85,"(b)",transform=ax4.transAxes,fontsize=20)
ax4.text(0.12,0.08,"(i)",transform = ax4.transAxes,fontsize=20,horizontalalignment='center')
ax2.text(0.12,0.08,"(ii)",transform = ax2.transAxes,fontsize=20,horizontalalignment='center')


pyplot.tight_layout()
fig.subplots_adjust(hspace=0,left=0.14,wspace=0.42,right=0.9)
pyplot.savefig(cwd+"\\OUTPUT\\Angle_variation.pdf")

pyplot.savefig(cwd+"\\OUTPUT\\Angle_variation.png")

pyplot.show()
